/*
 * Decompiled with CFR 0.152.
 */
package cis.common.digsig.signer.ui;

import cis.common.digsig.certificate.KeyStoreContainerType;
import cis.common.digsig.signer.ui.AboutUI;
import cis.common.digsig.signer.ui.CertificateExtractionFailureException;
import cis.common.digsig.signer.ui.CertificateListItem;
import cis.common.digsig.signer.ui.CertificateListModel;
import cis.common.digsig.signer.ui.CertificateSelectorController;
import cis.common.digsig.signer.ui.Constants;
import cis.common.digsig.signer.ui.LibraryFileFilter;
import cis.common.digsig.signer.ui.PfxFileFilter;
import cis.common.digsig.support.CertificateDataHelper;
import cis.common.digsig.support.CertificationChainDetails;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CertificateSelectorUI
extends JFrame {
    private LibraryFileFilter libraryFileFilter;
    private PfxFileFilter pfxFileFilter;
    private CertificateSelectorController certificateSelectorController;
    private AboutUI aboutUI = new AboutUI();
    private JButton jButtonPfx;
    private JButton jButtonSelectFile;
    private JButton jButtonSelectNewCertificate;
    private JButton jButtonSelectPfxFile;
    private JButton jButtonSmartCard;
    private JButton jButtonWindowsKeyStore;
    private JCheckBox jCheckBoxCertSelected;
    private JLabel jLabelCertSelected;
    private JLabel jLabelIssuer;
    private JLabel jLabelKeyStore;
    private JLabel jLabelPfx;
    private JLabel jLabelPfx2;
    private JLabel jLabelPfxPassword;
    private JLabel jLabelSelectedPfx;
    private JLabel jLabelSelectedSmartCardDll;
    private JLabel jLabelSerialNumber;
    private JLabel jLabelSmartCardDll;
    private JLabel jLabelSmartCardDll2;
    private JLabel jLabelSmartCardPassword;
    private JLabel jLabelSubject;
    private JLabel jLabelValidTo;
    private JLabel jLableValdiFrom;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemClose;
    private JMenu jMenuSigner;
    private JPanel jPanelKeyStore;
    private JPanel jPanelPfx;
    private JPanel jPanelSmartCard;
    private JPanel jPanelUpper;
    private JPasswordField jPasswordPfx;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPasswordField jSmartCardPassword;
    private JTabbedPane jTabbedPanel;
    private JTextField jTextIssuer;
    private JTextField jTextPfxLocation;
    private JTextField jTextSerialNumber;
    private JTextField jTextSmartCardDll;
    private JTextField jTextSubject;
    private JTextField jTextValidFrom;
    private JTextField jTextValidTo;
    private JList<Object> jWindowsKeyStoreList;

    @Autowired
    public CertificateSelectorUI(LibraryFileFilter libraryFileFilter, PfxFileFilter pfxFileFilter, CertificateSelectorController certificateSelectorController) {
        this.libraryFileFilter = libraryFileFilter;
        this.pfxFileFilter = pfxFileFilter;
        this.certificateSelectorController = certificateSelectorController;
        this.initializeFrame();
    }

    public CertificateSelectorUI() {
        this.initializeFrame();
    }

    private void initializeFrame() {
        this.initComponents();
        this.resetLangauge();
        this.loadDefaultValues();
        try {
            this.certificateSelectorController.loadKeyStoreFromWindowsPersonalKeystore();
            this.addWindowsKeyStoreCertificatesToList();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            Logger.getLogger(CertificateSelectorUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void runExtractor(KeyStoreContainerType strategy, String fileLocation, String passcode, CertificateListItem cli) {
        try {
            CertificationChainDetails extractorResult = null;
            extractorResult = this.certificateSelectorController.runExtractor(strategy, fileLocation, passcode, cli);
            if (extractorResult != null) {
                this.jTextIssuer.setText(extractorResult.getIssuerString());
                this.jTextSerialNumber.setText(extractorResult.getSerialNumber());
                this.jTextValidFrom.setText(extractorResult.getValidFrom());
                this.jTextValidTo.setText(extractorResult.getValidTo());
                this.jTextSubject.setText(this.truncateText(CertificateDataHelper.getSubjectName((String)extractorResult.getSubject()), 18));
            }
        }
        catch (CertificateExtractionFailureException dse) {
            String errorMessage = dse.getMessage();
            JOptionPane.showMessageDialog((java.awt.Component)this, Constants.getMessage((String)"signer.cert.extract.error"), Constants.getMessage((String)"signer.generic.error"), 0);
            Logger.getLogger(CertificateSelectorUI.class.getName()).log(Level.SEVERE, null, errorMessage);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            JOptionPane.showMessageDialog((java.awt.Component)this, Constants.getMessage((String)"signer.fs.access.error"), Constants.getMessage((String)"signer.generic.error"), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((java.awt.Component)this, Constants.getMessage((String)"signer.generic.error"), Constants.getMessage((String)"signer.generic.error"), 0);
        }
    }

    private void addWindowsKeyStoreCertificatesToList() throws KeyStoreException {
        CertificateListModel certListModel = this.certificateSelectorController.addWindowsKeyStoreCertificatesToList();
        if (certListModel != null) {
            this.jWindowsKeyStoreList.setModel(certListModel);
            this.jWindowsKeyStoreList.setSelectionMode(0);
        }
    }

    private String truncateText(String subjectName, int value) {
        if (subjectName != null) {
            if (subjectName.length() > 0) {
                if (subjectName.length() > value) {
                    return subjectName.substring(0, value) + "...";
                }
                return subjectName;
            }
            return subjectName;
        }
        return subjectName;
    }

    private void initComponents() {
        this.jPanelUpper = new JPanel();
        this.jLabelIssuer = new JLabel();
        this.jTextIssuer = new JTextField();
        this.jLabelSerialNumber = new JLabel();
        this.jTextSerialNumber = new JTextField();
        this.jLabelSubject = new JLabel();
        this.jTextSubject = new JTextField();
        this.jLableValdiFrom = new JLabel();
        this.jTextValidFrom = new JTextField();
        this.jLabelValidTo = new JLabel();
        this.jTextValidTo = new JTextField();
        this.jLabelCertSelected = new JLabel();
        this.jCheckBoxCertSelected = new JCheckBox();
        this.jButtonSelectNewCertificate = new JButton();
        this.jTabbedPanel = new JTabbedPane();
        this.jPanelKeyStore = new JPanel();
        this.jLabelKeyStore = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jWindowsKeyStoreList = new JList();
        this.jButtonWindowsKeyStore = new JButton();
        this.jPanelSmartCard = new JPanel();
        this.jButtonSmartCard = new JButton();
        this.jSmartCardPassword = new JPasswordField();
        this.jLabelSmartCardDll = new JLabel();
        this.jTextSmartCardDll = new JTextField();
        this.jLabelSmartCardPassword = new JLabel();
        this.jButtonSelectFile = new JButton();
        this.jLabelSelectedSmartCardDll = new JLabel();
        this.jLabelSmartCardDll2 = new JLabel();
        this.jPanelPfx = new JPanel();
        this.jButtonPfx = new JButton();
        this.jPasswordPfx = new JPasswordField();
        this.jLabelPfx = new JLabel();
        this.jTextPfxLocation = new JTextField();
        this.jLabelPfxPassword = new JLabel();
        this.jButtonSelectPfxFile = new JButton();
        this.jLabelSelectedPfx = new JLabel();
        this.jLabelPfx2 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuSigner = new JMenu();
        this.jMenuItemAbout = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemClose = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(650, 450));
        this.setResizable(false);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanelUpper.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanelUpper.setLayout(new GridBagLayout());
        this.jLabelIssuer.setText("Issuer:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jLabelIssuer, gridBagConstraints);
        this.jTextIssuer.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.jPanelUpper.add((java.awt.Component)this.jTextIssuer, gridBagConstraints);
        this.jLabelSerialNumber.setText("Serial Number:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jLabelSerialNumber, gridBagConstraints);
        this.jTextSerialNumber.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.jPanelUpper.add((java.awt.Component)this.jTextSerialNumber, gridBagConstraints);
        this.jLabelSubject.setText("Subject:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jLabelSubject, gridBagConstraints);
        this.jTextSubject.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.jPanelUpper.add((java.awt.Component)this.jTextSubject, gridBagConstraints);
        this.jLableValdiFrom.setText("Valid From:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jLableValdiFrom, gridBagConstraints);
        this.jTextValidFrom.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.jPanelUpper.add((java.awt.Component)this.jTextValidFrom, gridBagConstraints);
        this.jLabelValidTo.setText("Valid To:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jLabelValidTo, gridBagConstraints);
        this.jTextValidTo.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.jPanelUpper.add((java.awt.Component)this.jTextValidTo, gridBagConstraints);
        this.jLabelCertSelected.setText("Certificate Selected?");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jLabelCertSelected, gridBagConstraints);
        this.jCheckBoxCertSelected.setForeground(new Color(200, 56, 53));
        this.jCheckBoxCertSelected.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jCheckBoxCertSelected, gridBagConstraints);
        this.jButtonSelectNewCertificate.setText("Select Another Cert.");
        this.jButtonSelectNewCertificate.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUpper.add((java.awt.Component)this.jButtonSelectNewCertificate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((java.awt.Component)this.jPanelUpper, gridBagConstraints);
        this.jPanelKeyStore.setLayout(new GridBagLayout());
        this.jLabelKeyStore.setText("Certificate CN | Certifiacate CA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelKeyStore.add((java.awt.Component)this.jLabelKeyStore, gridBagConstraints);
        this.jWindowsKeyStoreList.setModel(new CertificateListModel());
        this.jWindowsKeyStoreList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jWindowsKeyStoreList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelKeyStore.add((java.awt.Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonWindowsKeyStore.setText("Select");
        this.jButtonWindowsKeyStore.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jPanelKeyStore.add((java.awt.Component)this.jButtonWindowsKeyStore, gridBagConstraints);
        this.jTabbedPanel.addTab("Windows KeyStore", this.jPanelKeyStore);
        this.jPanelSmartCard.setPreferredSize(new Dimension(500, 200));
        this.jPanelSmartCard.setLayout(new GridBagLayout());
        this.jButtonSmartCard.setText("Select");
        this.jButtonSmartCard.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        this.jPanelSmartCard.add((java.awt.Component)this.jButtonSmartCard, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanelSmartCard.add((java.awt.Component)this.jSmartCardPassword, gridBagConstraints);
        this.jLabelSmartCardDll.setForeground(new Color(200, 53, 56));
        this.jLabelSmartCardDll.setText("Please select the installed libaray (.dll or .so file) to access the SmartCard by pressing the Browse button.  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.jPanelSmartCard.add((java.awt.Component)this.jLabelSmartCardDll, gridBagConstraints);
        this.jTextSmartCardDll.setEditable(false);
        this.jTextSmartCardDll.setFont(new Font("Dialog", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        this.jPanelSmartCard.add((java.awt.Component)this.jTextSmartCardDll, gridBagConstraints);
        this.jLabelSmartCardPassword.setText("Please enter the password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanelSmartCard.add((java.awt.Component)this.jLabelSmartCardPassword, gridBagConstraints);
        this.jButtonSelectFile.setText("Browse");
        this.jButtonSelectFile.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(45, 4, 0, 0);
        this.jPanelSmartCard.add((java.awt.Component)this.jButtonSelectFile, gridBagConstraints);
        this.jLabelSelectedSmartCardDll.setText("Selected File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        this.jPanelSmartCard.add((java.awt.Component)this.jLabelSelectedSmartCardDll, gridBagConstraints);
        this.jLabelSmartCardDll2.setForeground(new Color(200, 53, 56));
        this.jLabelSmartCardDll2.setText("Enter the pasword to access the SmartCard and then press the Select Button.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.jPanelSmartCard.add((java.awt.Component)this.jLabelSmartCardDll2, gridBagConstraints);
        this.jTabbedPanel.addTab("SmartCards", this.jPanelSmartCard);
        this.jPanelPfx.setPreferredSize(new Dimension(500, 200));
        this.jPanelPfx.setLayout(new GridBagLayout());
        this.jButtonPfx.setText("Select");
        this.jButtonPfx.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        this.jPanelPfx.add((java.awt.Component)this.jButtonPfx, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanelPfx.add((java.awt.Component)this.jPasswordPfx, gridBagConstraints);
        this.jLabelPfx.setForeground(new Color(200, 53, 56));
        this.jLabelPfx.setText("Please select a .pfx file to use by pressing the Browse button.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.jPanelPfx.add((java.awt.Component)this.jLabelPfx, gridBagConstraints);
        this.jTextPfxLocation.setEditable(false);
        this.jTextPfxLocation.setFont(new Font("Dialog", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        this.jPanelPfx.add((java.awt.Component)this.jTextPfxLocation, gridBagConstraints);
        this.jLabelPfxPassword.setText("Please enter the password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanelPfx.add((java.awt.Component)this.jLabelPfxPassword, gridBagConstraints);
        this.jButtonSelectPfxFile.setText("Browse");
        this.jButtonSelectPfxFile.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(45, 4, 0, 0);
        this.jPanelPfx.add((java.awt.Component)this.jButtonSelectPfxFile, gridBagConstraints);
        this.jLabelSelectedPfx.setText("Selected File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        this.jPanelPfx.add((java.awt.Component)this.jLabelSelectedPfx, gridBagConstraints);
        this.jLabelPfx2.setForeground(new Color(200, 53, 56));
        this.jLabelPfx2.setText("Enter the pasword to access the .pfx file and then press the Select Button.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.jPanelPfx.add((java.awt.Component)this.jLabelPfx2, gridBagConstraints);
        this.jTabbedPanel.addTab(".pfx", this.jPanelPfx);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((java.awt.Component)this.jTabbedPanel, gridBagConstraints);
        this.jTabbedPanel.getAccessibleContext().setAccessibleName("Windows KeyStore");
        this.jMenuSigner.setText("File");
        this.jMenuItemAbout.setText("About");
        this.jMenuItemAbout.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jMenuSigner.add(this.jMenuItemAbout);
        this.jMenuSigner.add(this.jSeparator1);
        this.jMenuItemClose.setText("Exit");
        this.jMenuItemClose.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jMenuSigner.add(this.jMenuItemClose);
        this.jMenuBar1.add(this.jMenuSigner);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter((FileFilter)this.libraryFileFilter);
        String libraryFileName = this.jTextSmartCardDll.getText();
        File directory = new File(libraryFileName).getParentFile();
        fileChooser.setCurrentDirectory(directory);
        if (fileChooser.showOpenDialog((java.awt.Component)this) == 0) {
            String selectedLibFile = fileChooser.getSelectedFile().getAbsolutePath();
            this.jTextSmartCardDll.setText(selectedLibFile);
        }
    }

    private void jButtonSmartCardActionPerformed(ActionEvent evt) {
        if (null == this.jTextSmartCardDll.getText() || this.jSmartCardPassword.getPassword().length == 0) {
            JOptionPane.showMessageDialog((java.awt.Component)this, Constants.getMessage((String)"signer.validation.missingtext"), Constants.getMessage((String)"signer.generic.error"), 0);
        } else {
            this.runExtractor(KeyStoreContainerType.SC, this.jTextSmartCardDll.getText(), new String(this.jSmartCardPassword.getPassword()), null);
            this.certificateSelectorController.updateConfigurationProperties(KeyStoreContainerType.SC.name(), this.jTextSmartCardDll.getText(), new String(this.jSmartCardPassword.getPassword()), null, this.jTextSubject.getText(), this.jTextIssuer.getText(), this.jTextSerialNumber.getText(), this.jTextValidFrom.getText(), this.jTextValidTo.getText());
            this.jPasswordPfx.setText("");
            this.jTextPfxLocation.setText("");
            this.updateJCheckBoxCertSelected();
            this.enableJbuttonSelectNewCert(this.certificateSelectorController.isCertificateSelected());
        }
    }

    private void jButtonWindowsKeyStoreActionPerformed(ActionEvent evt) {
        if (this.jWindowsKeyStoreList.getSelectedIndex() != -1) {
            CertificateListItem ci = (CertificateListItem)this.jWindowsKeyStoreList.getSelectedValue();
            this.runExtractor(KeyStoreContainerType.WKS, null, null, ci);
            this.certificateSelectorController.updateConfigurationProperties(KeyStoreContainerType.WKS.name(), null, null, ci.getItemId(), this.jTextSubject.getText(), this.jTextIssuer.getText(), this.jTextSerialNumber.getText(), this.jTextValidFrom.getText(), this.jTextValidTo.getText());
            this.jPasswordPfx.setText("");
            this.jTextPfxLocation.setText("");
            this.jSmartCardPassword.setText("");
            this.jTextSmartCardDll.setText("");
            this.updateJCheckBoxCertSelected();
            this.enableJbuttonSelectNewCert(this.certificateSelectorController.isCertificateSelected());
        } else {
            JOptionPane.showMessageDialog((java.awt.Component)this, Constants.getMessage((String)"signer.validation.nothingselected"), Constants.getMessage((String)"signer.generic.error"), 0);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        this.dispose();
        System.exit(0);
    }

    private void jButtonSelectPfxFileActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter((FileFilter)this.pfxFileFilter);
        String libraryFileName = this.jTextPfxLocation.getText();
        File directory = new File(libraryFileName).getParentFile();
        fileChooser.setCurrentDirectory(directory);
        if (fileChooser.showOpenDialog((java.awt.Component)this) == 0) {
            String selectedLibFile = fileChooser.getSelectedFile().getAbsolutePath();
            this.jTextPfxLocation.setText(selectedLibFile);
        }
    }

    private void jButtonPfxActionPerformed(ActionEvent evt) {
        if (null == this.jTextPfxLocation.getText() || this.jPasswordPfx.getPassword().length == 0) {
            JOptionPane.showMessageDialog((java.awt.Component)this, Constants.getMessage((String)"signer.validation.missing.pfx"), Constants.getMessage((String)"signer.generic.error"), 0);
        } else {
            this.runExtractor(KeyStoreContainerType.PFX, this.jTextPfxLocation.getText(), new String(this.jPasswordPfx.getPassword()), null);
            this.certificateSelectorController.updateConfigurationProperties(KeyStoreContainerType.PFX.name(), this.jTextPfxLocation.getText(), new String(this.jPasswordPfx.getPassword()), null, this.jTextSubject.getText(), this.jTextIssuer.getText(), this.jTextSerialNumber.getText(), this.jTextValidFrom.getText(), this.jTextValidTo.getText());
            this.jSmartCardPassword.setText("");
            this.jTextSmartCardDll.setText("");
            this.updateJCheckBoxCertSelected();
            this.enableJbuttonSelectNewCert(this.certificateSelectorController.isCertificateSelected());
        }
    }

    private void jMenuItemAboutActionPerformed(ActionEvent evt) {
        this.aboutUI.setVisible(true);
    }

    private void jMenuItemCloseActionPerformed(ActionEvent evt) {
        this.dispose();
        System.exit(0);
    }

    private void jButtonSelectNewCertificateActionPerformed(ActionEvent evt) {
        this.enableJbuttonSelectNewCert(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CertificateSelectorUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CertificateSelectorUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CertificateSelectorUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CertificateSelectorUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new CertificateSelectorUI().setVisible(true));
    }

    private void resetLangauge() {
        this.jTabbedPanel.removeAll();
        this.jPanelUpper.setBorder(BorderFactory.createTitledBorder(Constants.getMessage((String)"signer.label.main.title")));
        this.jLabelIssuer.setText(Constants.getMessage((String)"signer.label.issuer"));
        this.jLabelSerialNumber.setText(Constants.getMessage((String)"signer.label.serialNumber"));
        this.jLabelSubject.setText(Constants.getMessage((String)"signer.label.subject"));
        this.jLableValdiFrom.setText(Constants.getMessage((String)"signer.label.validFrom"));
        this.jLabelValidTo.setText(Constants.getMessage((String)"signer.label.validTo"));
        this.jLabelKeyStore.setText(Constants.getMessage((String)"signer.label.smartcard.list"));
        this.jButtonWindowsKeyStore.setText(Constants.getMessage((String)"signer.label.select"));
        this.jPanelKeyStore.setToolTipText(Constants.getMessage((String)"signer.tooltip.main.text1"));
        this.jTabbedPanel.addTab(Constants.getMessage((String)"signer.label.windowskeystore.tab"), this.jPanelKeyStore);
        this.jLabelSmartCardDll.setText(Constants.getMessage((String)"signer.label.select.pkcs11.library"));
        this.jLabelSmartCardDll2.setText(Constants.getMessage((String)"signer.label.select.pkcs11.library2"));
        this.jLabelSmartCardPassword.setText(Constants.getMessage((String)"signer.label.select.keystore.password"));
        this.jButtonSmartCard.setText(Constants.getMessage((String)"signer.label.select"));
        this.jPanelSmartCard.setToolTipText(Constants.getMessage((String)"signer.tooltip.main.text2"));
        this.jTabbedPanel.addTab(Constants.getMessage((String)"signer.label.smartcard.tab"), this.jPanelSmartCard);
        this.jButtonPfx.setText(Constants.getMessage((String)"signer.label.select"));
        this.jLabelPfx.setText(Constants.getMessage((String)"signer.label.select.pfx"));
        this.jLabelPfx2.setText(Constants.getMessage((String)"signer.label.select.pfx2"));
        this.jLabelPfxPassword.setText(Constants.getMessage((String)"signer.label.select.keystore.password"));
        this.jPanelPfx.setToolTipText(Constants.getMessage((String)"signer.tooltip.main.text3"));
        this.jTabbedPanel.addTab(Constants.getMessage((String)"signer.label.pfx.tab"), this.jPanelPfx);
        this.jMenuSigner.setText(Constants.getMessage((String)"signer.menu.file"));
        this.jMenuItemAbout.setText(Constants.getMessage((String)"signer.menu.item.about"));
        this.jMenuItemClose.setText(Constants.getMessage((String)"signer.menu.item.exit"));
        this.jLabelCertSelected.setText(Constants.getMessage((String)"signer.label.cert.selected"));
        this.setTitle(Constants.getMessage((String)"signer.frame") + " " + Constants.getMessage((String)"signer.version"));
    }

    private void loadDefaultValues() {
        this.jPasswordPfx.setText(this.certificateSelectorController.loadPfxPasscode());
        this.jSmartCardPassword.setText(this.certificateSelectorController.loadSmartCardPasscode());
        this.jTextSmartCardDll.setText(this.certificateSelectorController.loadSmartCardFileLocation());
        this.jTextPfxLocation.setText(this.certificateSelectorController.loadPfxFileLocation());
        this.jTextIssuer.setText(this.certificateSelectorController.loadCertificateIssuer());
        this.jTextSerialNumber.setText(this.certificateSelectorController.loadCertificateSerialnumber());
        this.jTextSubject.setText(this.certificateSelectorController.loadCertificateSubject());
        this.jTextValidFrom.setText(this.certificateSelectorController.loadCertificateValidFrom());
        this.jTextValidTo.setText(this.certificateSelectorController.loadCertificateValidTo());
        this.jCheckBoxCertSelected.setSelected(this.certificateSelectorController.isCertificateSelected());
        this.updateJCheckBoxCertSelected();
        this.enableJbuttonSelectNewCert(this.certificateSelectorController.isCertificateSelected());
    }

    private void enableJbuttonSelectNewCert(boolean isCertSelected) {
        this.jButtonPfx.setEnabled(!isCertSelected);
        this.jButtonSelectFile.setEnabled(!isCertSelected);
        this.jButtonSelectPfxFile.setEnabled(!isCertSelected);
        this.jButtonSmartCard.setEnabled(!isCertSelected);
        this.jButtonWindowsKeyStore.setEnabled(!isCertSelected);
        this.jWindowsKeyStoreList.setEnabled(!isCertSelected);
        this.jSmartCardPassword.setEditable(!isCertSelected);
        this.jPasswordPfx.setEditable(!isCertSelected);
        this.jButtonSelectNewCertificate.setEnabled(isCertSelected);
    }

    private void updateJCheckBoxCertSelected() {
        if (!this.certificateSelectorController.isCertificateSelected()) {
            this.jCheckBoxCertSelected.setText("");
            this.jCheckBoxCertSelected.setSelected(false);
        } else {
            this.jCheckBoxCertSelected.setSelected(true);
            this.jCheckBoxCertSelected.setText(Constants.getMessage((String)this.certificateSelectorController.loadKeyStoreType().name()));
        }
    }

    static /* synthetic */ void access$000(CertificateSelectorUI x0, WindowEvent x1) {
        x0.formWindowClosed(x1);
    }

    static /* synthetic */ void access$100(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jButtonSelectNewCertificateActionPerformed(x1);
    }

    static /* synthetic */ void access$200(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jButtonWindowsKeyStoreActionPerformed(x1);
    }

    static /* synthetic */ void access$300(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jButtonSmartCardActionPerformed(x1);
    }

    static /* synthetic */ void access$400(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jButtonSelectFileActionPerformed(x1);
    }

    static /* synthetic */ void access$500(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jButtonPfxActionPerformed(x1);
    }

    static /* synthetic */ void access$600(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jButtonSelectPfxFileActionPerformed(x1);
    }

    static /* synthetic */ void access$700(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jMenuItemAboutActionPerformed(x1);
    }

    static /* synthetic */ void access$800(CertificateSelectorUI x0, ActionEvent x1) {
        x0.jMenuItemCloseActionPerformed(x1);
    }
}

